// $Id: CMidiFile.cpp,v 1.3 2007/02/08 21:08:09 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CMidiFile.hpp"
using Exponent::Midi::CMidiFile;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CMidiFile, CCountedObject);

//	===========================================================================
CMidiFile::CMidiFile()
{	
	EXPONENT_CLASS_CONSTRUCTION(CMidiFile);
}

//	===========================================================================
CMidiFile::~CMidiFile()
{
	EXPONENT_CLASS_DESTRUCTION(CMidiFile);
	m_stream.closeStream();
}

//	===========================================================================
bool CMidiFile::openFile(CFileStream::EStreamMode mode, const CSystemString &filename)
{
	return m_stream.openStream(filename, mode, false);
}

//	===========================================================================
bool CMidiFile::closeFile()
{
	m_stream.closeStream();
	return true;
}

//	===========================================================================
CString CMidiFile::getFileExtension()
{
	return "mid";
}

//	===========================================================================
bool CMidiFile::isValidFormat(const CSystemString &filename)
{
	CFileStream stream(filename, CFileStream::e_input, false);
	SMTHDChunk headChunk;
	return readFileHeader(stream, headChunk);
}

//	===========================================================================
bool CMidiFile::isValidMTHDChunk(const SMTHDChunk &chunk)
{
	return (chunk.m_mthdChunk[0] == 'M' && 
			chunk.m_mthdChunk[1] == 'T' && 
			chunk.m_mthdChunk[2] == 'h' && 
			chunk.m_mthdChunk[3] == 'd' && 
			chunk.m_mthdSize     == 6);			// Always 6 for MTHD 
}

//	===========================================================================
bool CMidiFile::isValidMTRKChunk(const SMTRKChunk &chunk)
{
	return (chunk.m_mtrkChunk[0] == 'M' && 
			chunk.m_mtrkChunk[1] == 'T' && 
			chunk.m_mtrkChunk[2] == 'r' && 
			chunk.m_mtrkChunk[3] == 'k');
}